/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.util.Stats;

final class GTStatisticsDataSource
extends GTDataSource {
    private String[] statistics_info;
    private Stats stats;
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTStatisticsDataSource(DatabaseConnection connection) {
        super(connection.getSystem());
        this.stats = connection.getDatabase().stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GTStatisticsDataSource init() {
        Stats stats = this.stats;
        synchronized (stats) {
            this.stats.set((int)(Runtime.getRuntime().freeMemory() / 1024L), "Runtime.memory.freeKB");
            this.stats.set((int)(Runtime.getRuntime().totalMemory() / 1024L), "Runtime.memory.totalKB");
            String[] key_set = this.stats.keyList();
            int glob_length = key_set.length * 2;
            this.statistics_info = new String[glob_length];
            for (int i = 0; i < glob_length; i += 2) {
                String key_name;
                this.statistics_info[i] = key_name = key_set[i / 2];
                this.statistics_info[i + 1] = this.stats.statString(key_name);
            }
        }
        return this;
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return this.statistics_info.length / 2;
    }

    public TObject getCellContents(int column, int row) {
        switch (column) {
            case 0: {
                return this.columnValue(column, this.statistics_info[row * 2]);
            }
            case 1: {
                return this.columnValue(column, this.statistics_info[row * 2 + 1]);
            }
        }
        throw new Error("Column out of bounds.");
    }

    public void dispose() {
        super.dispose();
        this.statistics_info = null;
        this.stats = null;
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRDatabaseStatistics"));
        def.addColumn(GTStatisticsDataSource.stringColumn("stat_name"));
        def.addColumn(GTStatisticsDataSource.stringColumn("value"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }
}

